//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module DATASOURCE.H
//
//-----------------------------------------------------------------------------------

#ifndef _DATASOURCE_H_
#define _DATASOURCE_H_


///////////////////////////////////////////////////////////////
// Includes
//
///////////////////////////////////////////////////////////////
#include "CEnum.h"
#include "Property.h"
#include "List.h"

///////////////////////////////////////////////////////////////
// Forwards
//
///////////////////////////////////////////////////////////////
class CMDIChild;
class COptionsDlg;
class CListBox;
class CAsynchNotify;
class CTransaction;


/////////////////////////////////////////////////////////////////
// CBase class
//
/////////////////////////////////////////////////////////////////
class CBase
{
public:
	//Constructors
	CBase(CMDIChild* pCMDIChild);
	virtual ~CBase();

	//IUnknown Helpers
	virtual ULONG	AddRef();
	virtual ULONG	Release();
	virtual HRESULT QueryInterface(REFIID riid);
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown) = 0;
	
	//Helpers
	virtual HRESULT ReleaseBase(CHAR* pszObject);
	virtual COptionsDlg* GetOptionsObj();
	
	//BackPointers
	CMDIChild*				m_pCMDIChild;

	//OLEDB Interfaces
	//[MANADATORY]
	IUnknown*				m_pIUnknown;
};



/////////////////////////////////////////////////////////////////
// CDataSource class
//
/////////////////////////////////////////////////////////////////
class CDataSource : public CBase
{
public:
	//Constructors
	CDataSource(CMDIChild* pCMDIChild);
	virtual ~CDataSource();

	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Members
	virtual BOOL	IsConnected();

	virtual HRESULT Connect(IUnknown* pIUnknown);
	virtual HRESULT SetProperties(ULONG cPropSets, DBPROPSET* rgPropSets);
	virtual HRESULT Initialize();

	virtual HRESULT CreateDataSource(IUnknown* pIUnknown, ULONG cPropSets, DBPROPSET* rgPropSets);
	virtual HRESULT CreateDataSource(CDataSource* pCDataSource);
	virtual HRESULT ReleaseDataSource();

	virtual HRESULT AdviseListeners();
	virtual HRESULT UnadviseListeners();

	virtual HRESULT		SetEnumInfo(ENUMINFO* pEnumInfo);
	virtual ENUMINFO*	GetEnumInfo();
	virtual HRESULT		GetClassID(REFCLSID clsid, WCHAR** ppwszProgID = NULL);

	virtual BOOL		IsMDProvider() { return m_EnumInfo.wType == DBSOURCETYPE_DATASOURCE_MDP; }

	//OLEDB Interfaces
	//[MANADATORY]
	IDBCreateSession*			m_pIDBCreateSession;			//DataSource interface
	IDBInitialize*				m_pIDBInitialize;				//DataSource interface
	IDBProperties*				m_pIDBProperties;				//DataSource interface
	IPersist*					m_pIPersist;					//DataSource interface

	//[OPTIONAL]
	IConnectionPointContainer*	m_pIConnectionPointContainer;	//DataSource interface
	IDBAsynchStatus*			m_pIDBAsynchStatus;				//DataSource interface
	IDBDataSourceAdmin*			m_pIDBDataSourceAdmin;			//DataSource interface
	IDBInfo*					m_pIDBInfo;						//DataSource interface
	IPersistFile*				m_pIPersistFile;				//DataSource interface
	ISupportErrorInfo*			m_pISupportErrorInfo;			//DataSource interface
		
	ISourcesRowset*				m_pISourcesRowset;				//Enumerator interface
	IParseDisplayName*			m_pIParseDisplayName;			//Enumerator interface

	//Extra interfaces
	IConnectionPoint*			m_pIConnectionPoint;			//Connection interface

	//Objects
	CAsynchNotify*				m_pCAsynchNotify;

	//DataSource info
	WCHAR*						m_pwszDataSource;
	WCHAR*						m_pwszDBMS;
	WCHAR*						m_pwszDBMSVer;

	WCHAR*						m_pwszProviderName;
	WCHAR*						m_pwszProviderDesc;

	//EnumInfo
	ENUMINFO					m_EnumInfo;

	//Data
	BOOL						m_fConnected;
};


/////////////////////////////////////////////////////////////////
// CSession class
//
/////////////////////////////////////////////////////////////////
class CSession : public CBase
{
public:
	//Constructors
	CSession(CMDIChild* pCMDIChild, CDataSource* pCDataSource);
	virtual ~CSession();

	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Methods
	virtual HRESULT CreateSession(REFIID riid = IID_IUnknown);
	virtual HRESULT CreateSession(CSession* pCSesssion);
	virtual HRESULT ReleaseSession();

	//OLEDB Interfaces
	//[MANDATORY]
	IGetDataSource*			m_pIGetDataSource;			//Session interface
	IOpenRowset*			m_pIOpenRowset;				//Session interface
	ISessionProperties*		m_pISessionProperties;		//Session interface

	//[OPTIONAL]
	IDBCreateCommand*		m_pIDBCreateCommand;		//Session interface
	IDBSchemaRowset*		m_pIDBSchemaRowset;			//Session interface
	IIndexDefinition*		m_pIIndexDefinition;		//Session interface
	ISupportErrorInfo*		m_pISupportErrorInfo;		//Session interface
	ITableDefinition*		m_pITableDefinition;		//Session interface
	ITransactionJoin*		m_pITransactionJoin;		//Session interface
	ITransactionLocal*		m_pITransactionLocal;		//Session interface
	ITransactionObject*		m_pITransactionObject;		//Session interface
	//BackPointers
	CDataSource*		m_pCDataSource;

	//Objects
	CTransaction*		m_pCTransaction;
};


/////////////////////////////////////////////////////////////////
// CCommand class
//
/////////////////////////////////////////////////////////////////
class CCommand : public CBase
{
public:
	//Constructors
	CCommand(CMDIChild* pCMDIChild, CSession* pCSession);
	virtual ~CCommand();

	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Methods
	virtual HRESULT CreateCommand(REFIID riid = IID_IUnknown);
	virtual HRESULT ReleaseCommand();

	//Helpers
	virtual HRESULT SetCommandText(WCHAR* pwszText);
	virtual HRESULT CreateParamAccessor(ULONG cParams, DBPARAMINFO* rgParamInfo);
	virtual HRESULT SetupBindings(ULONG cParams, DBPARAMINFO* rgParamInfo, ULONG* cBindings, DBBINDING** prgBindings, ULONG* pcRowSize = NULL, BOOL* pbOutofLine = NULL);
	virtual HRESULT CreateAccessor(DBACCESSORFLAGS dwAccessorFlags, ULONG cBindings, DBBINDING* rgBindings, ULONG cRowSize, HACCESSOR* phAccessor);
	virtual HRESULT ReleaseAccessor(HACCESSOR* phAccessor);

	//OLEDB Interfaces
	//[MANDATORY]
	IAccessor*				m_pIAccessor;				//Command interface
	IColumnsInfo*			m_pIColumnsInfo;			//Command interface
	ICommand*				m_pICommand;				//Command interface
	ICommandProperties*		m_pICommandProperties;		//Command interface
	ICommandText*			m_pICommandText;			//Command interface
	IConvertType*			m_pIConvertType;			//Command interface
	//[OPTIONAL]
	IColumnsRowset*			m_pIColumnsRowset;			//Command interface
	ICommandPrepare*		m_pICommandPrepare;			//Command interface
	ICommandWithParameters*	m_pICommandWithParameters;	//Command interface
	ISupportErrorInfo*		m_pISupportErrorInfo;		//Command interface

	//BackPointers
	CSession*				m_pCSession;

	//Parameters
	ULONG					m_cParamBindings;
	DBBINDING*				m_rgParamBindings;
	DBPARAMS				m_ParamInfo;
};



/////////////////////////////////////////////////////////////////
// CTransaction class
//
/////////////////////////////////////////////////////////////////
class CTransaction : public CBase
{
public:
	//Constructors
	CTransaction(CMDIChild* pCMDIChild);
	virtual ~CTransaction();

	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Methods
	virtual HRESULT CreateObject(IUnknown* pIUnknown);
	virtual HRESULT ReleaseObject();

	//Helpers

	//OLEDB Interfaces
	//[MANDATORY]
	ITransaction*					m_pITransaction;				//Transaction interface
	IConnectionPointContainer*		m_pIConnectionPointContainer;	//Transaction interface

	//[OPTIONAL]
	ISupportErrorInfo*				m_pISupportErrorInfo;			//Transaction interface

	//Extra Interfaces
	ITransactionOptions*			m_pITransactionOptions;			//Session interface
};


/////////////////////////////////////////////////////////////////
// CError class
//
/////////////////////////////////////////////////////////////////
class CError : public CBase
{
public:
	//Constructors
	CError(CMDIChild* pCMDIChild);
	virtual ~CError();

	//IUnknown Helpers
	virtual HRESULT SetInterface(REFIID riid, IUnknown* pIUnknown);

	//Methods
	virtual HRESULT GetErrorInfo();
	virtual HRESULT ReleaseError();

	//Helpers
	virtual HRESULT SetErrorInfo();

	//OLEDB Interfaces
	//[MANDATORY]
	IErrorInfo*				m_pIErrorInfo;				//Error interface
	IErrorRecords*			m_pIErrorRecords;			//Error interface

	//[OPTIONAL]
	ISQLErrorInfo*			m_pISQLErrorInfo;			//Error interface
};


///////////////////////////////////////////////////////////////////////////////
// Class CAggregate
// 
///////////////////////////////////////////////////////////////////////////////
extern const GUID IID_IAggregate;

class CAggregate : public IUnknown
{
public:
	CAggregate();
	virtual ~CAggregate();

	//IUnknown
	virtual STDMETHODIMP_(ULONG)	AddRef(void);
	virtual STDMETHODIMP_(ULONG)	Release(void);
	virtual STDMETHODIMP QueryInterface(REFIID riid, LPVOID *ppv);

	//Helpers
	virtual ULONG GetRefCount();

	//Data
	IUnknown*	m_pIUnkInner;

protected:
	//Data
	ULONG		m_cRef;
};


#endif	//_DATASOURCE_H_
